CREATE TABLE "bit_data" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"bit_number" text,
	"iadc" text,
	"size" text,
	"manufacturer" text,
	"serial_number" text,
	"type" text,
	"jets" text,
	"tfa" text,
	"md_in" text,
	"md_out" text,
	"tvd_out" text,
	"feet" text,
	"hours" text,
	"average_rop" text,
	"wob" text,
	"rpm" text,
	"i_row" text,
	"o_row" text,
	"dc" text,
	"loc" text,
	"b" text,
	"g" text,
	"pressure" text,
	"gpm" text,
	"jet_vel" text,
	"dp_av" text,
	"dc_av" text,
	"bit_hhp" text,
	"other" text,
	"pooh_reason" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "bulks" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"bulk" text,
	"value" text,
	"drill_wtr" text,
	"pot_wtr" text,
	"fuel_bbls" text,
	"barite_sx" text,
	"bentonite_sx" text,
	"cement_g_sx" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "chat_messages" (
	"id" serial PRIMARY KEY NOT NULL,
	"user_id" varchar(255) NOT NULL,
	"role" varchar(50) NOT NULL,
	"content" text NOT NULL,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "companies" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"company" text,
	"category" text,
	"no_of_persons" text,
	"operating_hrs" text,
	"on_location_hrs" text,
	"total" varchar(200),
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "drill_string" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"order_num" text,
	"component" text,
	"provider" text,
	"nominal_size" text,
	"joints" text,
	"od_size" text,
	"id_size" text,
	"length" text,
	"top_thread" text,
	"bottom_thread" text,
	"weight" text,
	"grade" text,
	"class" text,
	"serial" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "drill_string_floats" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"float" text,
	"bha_hrs" text,
	"string_wt" text,
	"pick_up" text,
	"slack_off" text,
	"rot_torque" text,
	"jars" text,
	"serial_hrs" text,
	"shock" text,
	"sub" text,
	"mud_motor" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "first_table" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"date" text,
	"well_no_and_charge" text,
	"wellbores" text,
	"objective" varchar(500),
	"rig" text,
	"foreman_engineer" text,
	"engineer" varchar(500),
	"manager" varchar(500),
	"thuraya_rig_forman" text,
	"rig_forman_vsat" varchar(500),
	"contractor_clerk" varchar(500),
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "fourth_table" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"lateral" text,
	"survey_md" text,
	"angle" text,
	"azimuth" text,
	"c_length" text,
	"tvd" text,
	"ns_coordinate" text,
	"ew_coordinate" text,
	"vertical_sec" text,
	"dls" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "lost_time_details" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer,
	"from_to" text,
	"hrs" text,
	"cum_hrs" text,
	"lt_id" text,
	"parent_lt_id" text,
	"type" text,
	"cause" text,
	"object" text,
	"resp_co" text,
	"depth" text,
	"lt_summary" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "miscellaneous" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"bop_test" text,
	"bop_drills" text,
	"wind" text,
	"sea" text,
	"weather" text,
	"dslta" text,
	"safety_meeting" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "mud_data" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"weight_pcf" text,
	"funnel_sec" text,
	"filtrate_wl_hthp" text,
	"filtrate_wl_api" text,
	"pv" text,
	"yp" text,
	"electrical_stability_volts" text,
	"rpm_3_6" text,
	"gels_sec_min" text,
	"ph" text,
	"ca_ppm" text,
	"cl_ppm" text,
	"fl_temp" text,
	"cake_hthp" text,
	"cake_api" text,
	"water_vol" text,
	"oil_vol" text,
	"solids_vol" text,
	"sand_vol" text,
	"lgs" text,
	"mbt" text,
	"mud_type" text,
	"ppt_spurt" text,
	"ppt_total" text,
	"water_well" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "mud_treatment" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"material" varchar(200),
	"quantity" varchar(200),
	"unit" varchar(200),
	"mud_treatment" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "multiple_files" (
	"id" serial PRIMARY KEY NOT NULL,
	"reg_name" varchar(191) NOT NULL,
	"sec_name" varchar(191) NOT NULL,
	"file_path" varchar(191) NOT NULL,
	"upload_date" date NOT NULL,
	"is_parsed" boolean DEFAULT false,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "other_data_table" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"comment" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "out_of_scope" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"from_to" text,
	"hrs" text,
	"cum_hrs" text,
	"doos_id" text,
	"type" text,
	"category" text,
	"hole_section" text,
	"lateral" text,
	"out_summary" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "repair_table" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"instrumentation" text,
	"other" text,
	"reporter" text,
	"computer" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "saved_queries" (
	"id" serial PRIMARY KEY NOT NULL,
	"user_id" varchar(255) NOT NULL,
	"name" varchar(255) NOT NULL,
	"query_config" text NOT NULL,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "second_table" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"depth" text,
	"last_24_hr_operations" text,
	"next_24_hr_plan" text,
	"location" text,
	"next_location" text,
	"days_since_spud_and_date" text,
	"formation_tops" text,
	"prev_depth" text,
	"depth_comments" text,
	"liner_size_tol_md_tvd" text,
	"last_csg_size_md_tvd" text,
	"footage" text,
	"distance_from_dha" text,
	"circ" text,
	"pres_depth" text,
	"progress" text,
	"casing_depth" text,
	"liner_depth" text,
	"rkh_depth" text,
	"current_operation" text,
	"next_operation" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "third_table" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"hrs" text,
	"from_to" text,
	"lateral" text,
	"hole_size" text,
	"cat" text,
	"major_op" text,
	"action" text,
	"object" text,
	"resp_co" text,
	"hole_depth" text,
	"event_depth" text,
	"summary_of_operations" text,
	"lt_type" text,
	"lt_id" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "trucks" (
	"id" serial PRIMARY KEY NOT NULL,
	"file_id" integer NOT NULL,
	"truck" text,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "sessions" (
	"sid" varchar PRIMARY KEY NOT NULL,
	"sess" jsonb NOT NULL,
	"expire" timestamp NOT NULL
);
--> statement-breakpoint
CREATE TABLE "users" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"email" varchar,
	"first_name" varchar,
	"last_name" varchar,
	"profile_image_url" varchar,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "users_email_unique" UNIQUE("email")
);
--> statement-breakpoint
CREATE TABLE "conversations" (
	"id" serial PRIMARY KEY NOT NULL,
	"title" text NOT NULL,
	"created_at" timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL
);
--> statement-breakpoint
CREATE TABLE "messages" (
	"id" serial PRIMARY KEY NOT NULL,
	"conversation_id" integer NOT NULL,
	"role" text NOT NULL,
	"content" text NOT NULL,
	"created_at" timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL
);
--> statement-breakpoint
ALTER TABLE "bit_data" ADD CONSTRAINT "bit_data_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "bulks" ADD CONSTRAINT "bulks_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "companies" ADD CONSTRAINT "companies_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "drill_string" ADD CONSTRAINT "drill_string_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "drill_string_floats" ADD CONSTRAINT "drill_string_floats_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "first_table" ADD CONSTRAINT "first_table_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "fourth_table" ADD CONSTRAINT "fourth_table_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "lost_time_details" ADD CONSTRAINT "lost_time_details_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "miscellaneous" ADD CONSTRAINT "miscellaneous_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "mud_data" ADD CONSTRAINT "mud_data_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "mud_treatment" ADD CONSTRAINT "mud_treatment_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "other_data_table" ADD CONSTRAINT "other_data_table_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "out_of_scope" ADD CONSTRAINT "out_of_scope_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "repair_table" ADD CONSTRAINT "repair_table_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "second_table" ADD CONSTRAINT "second_table_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "third_table" ADD CONSTRAINT "third_table_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "trucks" ADD CONSTRAINT "trucks_file_id_multiple_files_id_fk" FOREIGN KEY ("file_id") REFERENCES "public"."multiple_files"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "messages" ADD CONSTRAINT "messages_conversation_id_conversations_id_fk" FOREIGN KEY ("conversation_id") REFERENCES "public"."conversations"("id") ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
CREATE INDEX "IDX_session_expire" ON "sessions" USING btree ("expire");