# ARMS - Advanced Reporting Management System

## Overview
ARMS is a modern web application for processing PDF drilling reports into a structured PostgreSQL database. It features a visual query builder for data exploration, an AI-powered chat assistant for natural language queries, an analytics dashboard with KPIs, and secure authentication via Google, GitHub, Apple, or email login.

## Recent Changes
- **2026-01-21**: Fixed PDF parsing and improved Files Table:
  - Fixed pdf-parse v2 API integration (PDFParse class with getText() method)
  - Made PDF parsing automatic after upload (no manual parsing needed)
  - Files Table now uses Year → Month → Files collapsible container view
  - Each rig report is extracted separately (e.g., 273 reports from single PDF)
  - Verified parsing: 3,699 records across all tables from single PDF
- **2026-01-20**: Comprehensive PDF parsing implementation (server/pdfParser.ts):
  - Follows legacy PHP MultiplefilesController.php logic exactly
  - Splits PDF by "Foreman(s)" keyword to separate each report
  - Extracts date, rig name, section name from each report
  - Populates all 16 tables: first_table, second_table, third_table, companies, bit_data, drill_string, drill_string_floats, mud_data, mud_treatment, lost_time_details, miscellaneous, trucks, bulks, repair_table, out_of_scope, other_data_table
  - Rig names come from PDF extraction, not manual entry
- **2026-01-20**: Added new pages matching legacy app navigation:
  - Files Table (/files-table) - View all files organized by Year/Month
  - ROP & Bit Report (/rop-bit-report) - Bit performance analysis
  - Saved Reports (/saved-reports) - View and load saved queries
- **2026-01-20**: Updated database schema to match legacy PHP application:
  - SecondTable: Added 13 new fields (depth, last_24_hr_operations, next_24_hr_plan, location, next_location, days_since_spud_and_date, formation_tops, depth_comments, liner_size_tol_md_tvd, last_csg_size_md_tvd, footage, distance_from_dha, circ)
  - Added OutOfScope table for out-of-scope drilling details
  - Added OtherDataTable for foreman remarks/comments
  - Query Builder now shows all 16 tables with comprehensive column listings
- **2026-01-20**: Configured OpenAI integration with Replit AI Integrations for AI chat assistant
- **2026-01-20**: Complete frontend and backend implementation with authentication, dashboard, query builder, file upload, AI chat, and reports pages

## User Preferences
- Professional blue color scheme (hsl(217, 91%, 60%)) suitable for industrial/engineering applications
- Dark/light mode support
- Clean, modern UI using shadcn/ui components

## Project Architecture

### Frontend (client/)
- React with TypeScript
- Vite for bundling
- Tailwind CSS for styling
- shadcn/ui components
- Wouter for routing
- TanStack Query for data fetching
- Pages:
  - Landing page (/)
  - Dashboard (/dashboard)
  - Upload Files (/upload)
  - Files Table (/files-table)
  - ROP & Bit Report (/rop-bit-report)
  - Saved Reports (/saved-reports)
  - Query Builder (/query-builder)
  - AI Chat (/chat)
  - Reports (/reports)

### Backend (server/)
- Express.js with TypeScript
- PostgreSQL database via Drizzle ORM
- Replit Auth for authentication (Google, GitHub, Apple, email)
- OpenAI integration via Replit AI Integrations

### Database Schema (shared/schema.ts)
- Auth tables: users, sessions
- ARMS tables: multiple_files, first_table (rig details), second_table (current operation), bit_data, drill_string, mud_data, companies, lost_time, trucks, bulks, survey_data, hole_data, casing_data, weather_data, cost_data, ai_chat_messages, saved_queries, and more

### Key Files
- `shared/schema.ts` - Database schema definitions
- `server/routes.ts` - API endpoints
- `server/storage.ts` - Database operations
- `client/src/App.tsx` - Main app with routing
- `client/src/pages/` - Page components
- `client/src/index.css` - Theme and styling

## Environment Variables
- `DATABASE_URL` - PostgreSQL connection string (auto-configured)
- `SESSION_SECRET` - Session encryption key
- `AI_INTEGRATIONS_OPENAI_API_KEY` - Replit AI Integrations key (auto-configured)
- `AI_INTEGRATIONS_OPENAI_BASE_URL` - Replit AI Integrations URL (auto-configured)

## Running the Project
The workflow "Start application" runs `npm run dev` which starts:
- Express backend server
- Vite frontend development server
- Both served on port 5000
